<?php
/**
 * The template for displaying comments.
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package physioplus
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>
<div class="col-md-12 comment-block">
    <div id="comments" class="comments-area">
        <?php
        // You can start editing here -- including this comment!
        if ( have_comments() ) : ?>
            <h2 class="comments-title">
                <?php
                    printf( // WPCS: XSS OK.
                        esc_html( _nx( 'One thought on &ldquo;%2$s&rdquo;', '%1$s thoughts on &ldquo;%2$s&rdquo;', get_comments_number(), 'comments title', 'physioplus' ) ),
                        number_format_i18n( get_comments_number() ),
                        '<span>' . get_the_title() . '</span>'
                    );
                ?>
            </h2>
    
            <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // Are there comments to navigate through? ?>
            <nav id="comment-nav-above" class="navigation comment-navigation" role="navigation">
                <h2 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'physioplus' ); ?></h2>
                <div class="nav-links">    
                    <div class="nav-previous"><?php previous_comments_link( esc_html__( 'Older Comments', 'physioplus' ) ); ?></div>
                    <div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments', 'physioplus' ) ); ?></div>    
                </div><!-- .nav-links -->
            </nav><!-- #comment-nav-above -->
            <?php endif; // Check for comment navigation. ?>
    
            <div class="comment-post comment-list">
            <ul class="comment-body listnone">
                <?php
                    wp_list_comments( array(
                        'style'      => 'li',
                        'callback' => 'physioplus_shape_comment',
                        'avatar_size' => 100
                    ) );
                ?>
            </ul><!-- .comment-list -->
            </div>
    
            <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // Are there comments to navigate through? ?>
            <nav id="comment-nav-below" class="navigation comment-navigation" role="navigation">
                <h2 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'physioplus' ); ?></h2>
                <div class="nav-links">    
                    <div class="nav-previous"><?php previous_comments_link( esc_html__( 'Older Comments', 'physioplus' ) ); ?></div>
                    <div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments', 'physioplus' ) ); ?></div>    
                </div><!-- .nav-links -->
            </nav><!-- #comment-nav-below -->
            <?php
            endif; // Check for comment navigation.
    
        endif; // Check for have_comments().
    
    
        // If comments are closed and there are comments, let's leave a little note, shall we?
        if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>
    
            <p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'physioplus' ); ?></p>
        <?php
        endif;
    
    
    /**
        Comment form.
    */
    $comment_form = array(
        'title_reply' => esc_html__('Leave A Comments', 'physioplus'),
        'title_reply_to' => esc_html__('Leave a Reply to %s', 'physioplus'),
        'comment_notes_before' => '',
        'fields' => array(
            'author' => '<div class="row"><div class="col-md-4"><div class="form-group"><label for="author" class="control-label">'.esc_attr__('Name','physioplus').'</label><input id="author" name="author" type="text" value="' . esc_attr($commenter['comment_author']) . '" class="form-control" /></div></div>',
            'email' => '<div class="col-md-4"><div class="form-group"><label for="email" class="control-label">'.esc_attr__('Email','physioplus').'</label><input id = "email" 
    name = "email" type = "text" value = "' . esc_attr($commenter['comment_author_email']) . '" class = "form-control" /></div></div>',
            'url' => '<div class="col-md-4"><div class="form-group"><label for="subject" class="control-label">'.esc_attr__('Subject','physioplus').'</label><input  id="subject" name="subject" type="text" value = "'.esc_attr($commenter['comment_author_url']).'" class = "form-control" /></div></div></div>',
        ),
        'label_submit' => esc_html__('Comment', 'physioplus'),
        'class_submit' => 'btn btn-default hvr-sweep-to-right',
        'logged_in_as' => '',
        'comment_field' => '',
        'comment_notes_after' => '',
        'class_form'=>'form-vertical',
        'label_submit' => esc_html__('Leave A comment', 'physioplus'),
        
            )
    ;
    $comment_form['comment_field'].='<div class="form-group"><textarea name = "comment" rows="7" id = "comment" class = "form-control" placeholder="'.esc_attr__('Comment','physioplus').'"></textarea></div>';	
    ?>
    <div class="row">
        <div class="col-md-12 leave-comments">
            <?php comment_form($comment_form); ?>
        </div>
    </div><!-- #comments -->
	</div>
</div>