<?php
/**
 *  Template Name: Blog Masonry
 *
 * @package physioplus
 */
get_header(); 

global $wp_query;

query_posts('post_type=post&post_status=publish&posts_per_page='.get_option('posts_per_page').'&paged='. get_query_var('paged'));
?>
<div class="main-container">
    <div class="container">
	    <div class="row">
              <div class="col-md-8 content-left"><!-- content left -->
                <?php if ( have_posts() ) :  ?>
                <?php /* Start the Loop */  ?>
                <div id="isotope" class="grid row content">
				<?php while ( have_posts() ) : the_post(); ?>
                <?php
                    /* Include the Post-Format-specific template for the content.
                     * If you want to override this in a child theme, then include a file
                     * called content-___.php (where ___ is the Post Format name) and that will be used instead.
                     */
                    get_template_part( 'template-parts/content', 'grid' );	
                ?>
                <?php endwhile; ?>
				</div>
                <div class="row">
                    <div class="col-md-4 col-md-offset-4"> 
                        <a class="load_more btn btn-default" data-nonce="<?php echo wp_create_nonce('physioplus_load_posts') ?>" href="javascript:;"><?php esc_html_e('Load more','physioplus');?></a>
                    </div>
                </div>

                <?php else : ?>
                <?php get_template_part( 'template-parts/content', 'none' ); ?>
                <?php endif; ?>             
              </div>
            <!-- /.content left -->
            <div class="col-md-4 sidebar"><!--sidebar-->
                <?php if ( is_active_sidebar( 'sidebar-1' ) ) { ?>
                    <?php dynamic_sidebar( 'sidebar-1' ); ?>
                <?php } ?>          
            </div>
            <!-- /.sidebar-->
          </div>
    </div>
</div><!-- /.main-container -->
<?php
get_footer();
?>