<?php
/**
 * The template for displaying all Doctor posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package physioplus
 */

get_header(); ?>
<div class="main-container"><!-- main-container -->
  <div class="container">
     <?php while ( have_posts() ) : the_post();
		   $meta_therapist_designation = get_post_meta( $post->ID, 'therapist_designation', true );
		   
		   $parent_post_id=$post->ID;
		   $parent_post_title=get_the_title();
	?>
    <div class="row trainer-profile">
      <div class="col-md-4 trainer-block">
        <div class="trainer-pic zoom-pic"> 
        <?php
		if ( has_post_thumbnail() ) { // check if the post has a Post Thumbnail assigned to it.
			the_post_thumbnail( 'full',array( 'class' => 'img-responsive' ) );
		}
		?>
        </div>
        <div class="trainer-caption">
          <h2><?php the_title(); ?></h2>
			<?php 
			  if($meta_therapist_designation)
			  {
				  echo '<span class="trainer-meta">'.$meta_therapist_designation.'</span>';
			  }
            ?>          
		</div>
      </div>
      <div class="col-md-offset-1 col-md-7 profile-desciption">
        <?php the_content(); ?>
      </div>
    </div>
    <?php endwhile; // End of the loop. ?>
	<?php 
	$args = array( 'post_type' => 'therapist','post_parent' => $parent_post_id);
	$trainer = new WP_Query( $args );

	$trainer_html='';
	if($trainer->have_posts())
	{
		$trainer_html.='<div class="row">
		  <div class="col-md-5 section-title">
			<h1>'.$parent_post_title.'\'s '.esc_html__('Team','physioplus').'</h1>
			<h5 class="small-title left">'.esc_html__('Meet My Trainers','physioplus').'</h5>
		  </div>
		</div>';
		$trainer_html.='<div class="row">';
		
		while ( $trainer->have_posts() ) : $trainer->the_post();
		
		$meta_therapist_designation = get_post_meta( $post->ID, 'therapist_designation', true );
		$trainer_html.='<div class="col-md-3 trainer-block">
	<div class="trainer-pic zoom-pic"> <a href="'.get_permalink($post->ID).'">'.get_the_post_thumbnail($post->ID,'full',array('class'=>'img-responsive')).'</a></div> <div class="trainer-caption">
	  <h2><a class="trainer-title" href="'.get_permalink($post->ID).'">'.get_the_title().'</a></h2>';

		if($meta_therapist_designation)
		{
		  $trainer_html.='<span class="trainer-meta">'.$meta_therapist_designation.'</span>';
		}

		$trainer_html.='</div> </div>';
		endwhile; 
			
		$trainer_html.='</div>';
	
		echo wp_kses($trainer_html,array('img' => array('class' => array(),'src' => array(),'width' => array(),'height' => array(),'sizes' => array(),'srcset' => array(),'alt' => array()),'div' => array('class' => array()),'a' => array('class' => array(),'href' => array()),'li' => array('class' => array()),'h1' => array('class' => array()),'h2' => array('class' => array()),'h5' => array('class' => array()),'span' => array('class' => array()),'i' => array('class' => array())));		
	}	

?>    
  </div>
</div>
<?php get_footer(); ?>
