<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package physioplus
 */
	
if( !is_front_page() && !is_page_template('page-templates/page-slider.php'))
{
?>
<div class="page-header"><!-- page-header -->
  <div class="container">
    <div class="row">
      <div class="col-md-12 page-title">
        <?php 
		 if( is_home() ){
			  echo '<h1>'.apply_filters( 'the_title', get_the_title( get_option( 'page_for_posts' ) ) ).'</h1>'; 
		 }
		 else if( is_singular() ){
			 the_title( '<h1>', '</h1>' );
		 }
		 else if( is_archive() ){
			 the_archive_title( '<h1>', '</h1>' );
		 }
		 else if( is_search() ){
			  echo '<h1> Search :'.get_search_query().'</h1>'; 
		 }
		 else if ( is_404() ) {
    		// add search form so that users can search other posts
			echo '<h1>'.esc_html__('404 Error','physioplus').'</h1>';
		}
		 else
		 {
			  the_title( '<h1>', '</h1>' );
		 }		 
		?>
      </div>
      <div class="col-md-12"><!-- breadcrumb -->
      <?php 
		if(function_exists('bcn_display')) :  
		echo '<ol class="breadcrumb">';
			bcn_display();
		echo '</ol>';			
		endif;	  
	  ?>
      </div>
      <!-- /.breadcrumb --> 
    </div>
  </div>
</div>
<?php } ?>